def getCombos(chars, k, indent=0):
    debugMsg = '.' * indent + "getCombos('" + chars + "', " + str(k) + ")"
    print(debugMsg + ', start.')
    if k == 0:
        # PRZYPADEK BAZOWY
        print(debugMsg + " przypadek bazowy. Zwracam ['']")
        # Jeżeli k jest równe zero, zwracam '' reprezentujący zbiór zera liter
        return ['']
    elif chars == '':
        # PRZYPADEK BAZOWY
        print(debugMsg + ' przypadek bazowy. Zwracam []')
        return [] # Niezależnie od k pusty ciąg znaków nie ma kombinacji

    # PRZYPADEK REKURENCYJNY
    combinations = []
    # Część pierwsza, szukamy kombinacji z głową:
    head = chars[:1]
    tail = chars[1:]
    print(debugMsg + " część pierwsza, szukam kombinacji z głową: '" + head + "'")
    tailCombos = getCombos(tail, k - 1, indent + 1)
    print('.' * indent + "Dodaję głowę '" + head + "'do kombinacji ogona:")
    for tailCombo in tailCombos:
        print('.' * indent + 'Nowe kombinacje', head + tailCombo)
        combinations.append(head + tailCombo)

    # Część druga, szukamy kombinacji bez głowy:
    print(debugMsg + " część druga, szukam kombinacji bez głowy: '" + head + "')")
    combinations.extend(getCombos(tail, k, indent + 1))

    print(debugMsg + ' rezultaty:', combinations)
    return combinations

print('Dwuelementowe kombinacje "ABC":')
print('Wynik:', getCombos('ABC', 2))
